/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.base;
public class OptionalTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.base.testModule";
}
public void testAbsent() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testAbsent();
}

public void testAsSet_absent() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testAsSet_absent();
}

public void testAsSet_absentIsImmutable() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testAsSet_absentIsImmutable();
}

public void testAsSet_present() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testAsSet_present();
}

public void testAsSet_presentIsImmutable() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testAsSet_presentIsImmutable();
}

public void testEqualsAndHashCode() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testEqualsAndHashCode();
}

public void testFromJavaUtil() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testFromJavaUtil();
}

public void testFromNullable() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testFromNullable();
}

public void testFromNullable_null() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testFromNullable_null();
}

public void testGet_absent() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testGet_absent();
}

public void testGet_present() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testGet_present();
}

public void testIsPresent_no() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testIsPresent_no();
}

public void testIsPresent_yes() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testIsPresent_yes();
}

public void testOf() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testOf();
}

public void testOf_null() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testOf_null();
}

public void testOrNull_absent() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testOrNull_absent();
}

public void testOrNull_present() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testOrNull_present();
}

public void testOr_Optional_absent() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testOr_Optional_absent();
}

public void testOr_Optional_present() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testOr_Optional_present();
}

public void testOr_T_absent() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testOr_T_absent();
}

public void testOr_T_present() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testOr_T_present();
}

public void testOr_nullSupplier_absent() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testOr_nullSupplier_absent();
}

public void testOr_nullSupplier_present() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testOr_nullSupplier_present();
}

public void testOr_supplier_absent() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testOr_supplier_absent();
}

public void testOr_supplier_present() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testOr_supplier_present();
}

public void testPresentInstances_allAbsent() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testPresentInstances_allAbsent();
}

public void testPresentInstances_allPresent() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testPresentInstances_allPresent();
}

public void testPresentInstances_callingIteratorTwice() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testPresentInstances_callingIteratorTwice();
}

public void testPresentInstances_somePresent() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testPresentInstances_somePresent();
}

public void testPresentInstances_wildcards() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testPresentInstances_wildcards();
}

public void testSampleCodeError1() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testSampleCodeError1();
}

public void testSampleCodeError2() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testSampleCodeError2();
}

public void testSampleCodeFine1() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testSampleCodeFine1();
}

public void testSampleCodeFine2() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testSampleCodeFine2();
}

public void testToJavaUtil_instance() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testToJavaUtil_instance();
}

public void testToJavaUtil_static() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testToJavaUtil_static();
}

public void testToString_absent() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testToString_absent();
}

public void testToString_present() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testToString_present();
}

public void testTransform_absent() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testTransform_absent();
}

public void testTransform_absent_functionReturnsNull() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testTransform_absent_functionReturnsNull();
}

public void testTransform_presentIdentity() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testTransform_presentIdentity();
}

public void testTransform_presentToString() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testTransform_presentToString();
}

public void testTransform_present_functionReturnsNull() throws Exception {
  com.google.common.base.OptionalTest testCase = new com.google.common.base.OptionalTest();
  testCase.testTransform_present_functionReturnsNull();
}
}
